/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-10-20
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALPROCESSOBJECT_H
#define SIGNALPROCESSOBJECT_H

#include "GeopsyCoreDLLExport.h"
#include "SignalProcess.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SignalProcessObject : public QObject
  {
    Q_OBJECT
  public:
    SignalProcessObject(SignalProcess * p, QObject * parent=nullptr);
    ~SignalProcessObject();

    Q_INVOKABLE void saveStep(QString tag);
    Q_INVOKABLE void restoreStep(QString tag);

    Q_INVOKABLE void fastFourierTransform(QString signalType);
    Q_INVOKABLE bool exportFile(QString filePath, bool useOriginalBaseName=false,
                                QString format=QString(), int maximumSignalsPerFile=0,
                                const QString& pickName=QString());
    Q_INVOKABLE QVariant header(int signalIndex, QString dataIndex);
    Q_INVOKABLE void setHeader(int signalIndex, QString dataIndex, QVariant value);

    Q_INVOKABLE int signalCount();
    Q_INVOKABLE void selectSignals(int startIndex=-1, int endIndex=-1, QString tag=QString());

    Q_INVOKABLE void removeTrend();
    Q_INVOKABLE void subtractValue(double val);
    Q_INVOKABLE void subtractSignal(int index);
    Q_INVOKABLE void subtractSignals(QString groupName);
    Q_INVOKABLE void multiply(double val);
    Q_INVOKABLE void filter(QString method, QString band, double fmin, double fmax, double param);
    Q_INVOKABLE void whiten();
    Q_INVOKABLE void agc(double width);
    Q_INVOKABLE void stddevClip(double factor);
    Q_INVOKABLE void shift(double dt);
    Q_INVOKABLE void overSample(double factor);
    Q_INVOKABLE void taper(QString range, QString taperParam);
    Q_INVOKABLE void cut(QString range);
    Q_INVOKABLE bool merge();
    Q_INVOKABLE bool mergeStations();
    Q_INVOKABLE void decimateAmplitude(int maxCount, double maxRef);
    Q_INVOKABLE void decimateTime(int factor);
    Q_INVOKABLE void waveletTransform(const MorletParameters& param);
    Q_INVOKABLE void stalta(double tsta, double tlta);
    Q_INVOKABLE void discreteFourierTransform();
    Q_INVOKABLE void rotateComponents(bool z, double rotz, bool n, double rotn, bool e, double rote);
    Q_INVOKABLE void correlations(double maxDelay, int referenceIndex=-1);
    Q_INVOKABLE void normalizedCorrelations(double maxDelay, int referenceIndex=-1);
    Q_INVOKABLE void convolution(int referenceIndex);
    Q_INVOKABLE void removeInstrumentalResponse(const InstrumentalResponse& sensor);
  private:
    SignalProcess * _process;
  };

} // namespace GeopsyCore

#endif // SIGNALPROCESSOBJECT_H

