/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-03-02
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALGROUPFACTORY_H
#define SIGNALGROUPFACTORY_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "AbstractSignalGroup.h"

namespace GeopsyCore {

#define REGISTER_SIGNALGROUP(_className_, _tagName_) \
  XMLREGISTER_HEAD(SignalGroupFactory, XMLClassCreator, _className_, _tagName_) \
  XMLREGISTER_TAIL(_className_)

#define SYNONYM_SIGNALGROUP(_synName_, _tagName_) \
  XMLSYNONYM(SignalGroupFactory, _synName_, _tagName_)

  class GEOPSYCORE_EXPORT SignalGroupFactory : public XMLClassFactory
  {
  public:
    inline AbstractSignalGroup * create(int id) const;
    inline AbstractSignalGroup * create(const QString& tag) const;

    static void init();
    static SignalGroupFactory * instance() {init(); return _self;}
  private:
    static SignalGroupFactory * _self;
  };

  inline AbstractSignalGroup * SignalGroupFactory::create(int id) const
  {
    return static_cast<AbstractSignalGroup *>(XMLClassFactory::create(id));
  }

  inline AbstractSignalGroup * SignalGroupFactory::create(const QString& tag) const
  {
    return static_cast<AbstractSignalGroup *>(XMLClassFactory::create(tag));
  }

} // namespace GeopsyCore

#endif // SIGNALGROUPFACTORY_H
