/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-28
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef METADATAINDEX_H
#define METADATAINDEX_H

#include <QtCore>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT MetaDataIndex
{
public:
  inline MetaDataIndex();
  inline MetaDataIndex(int id, int subId=0, const QString& index=QString());
  inline MetaDataIndex(const MetaDataIndex& o);

  bool operator<(const MetaDataIndex& o) const;
  bool isValid() const {return _id>=0;}

  int id() const {return _id;}
  int subId() const {return _subId;}
  const QString& index() const {return _index;}

  void setIndex(const QString& i) {_index=i;}
private:
  int _id;
  int _subId;
  QString _index;
};

inline MetaDataIndex::MetaDataIndex()
{
  _id=-1;
  _subId=0;
}

inline MetaDataIndex::MetaDataIndex(int id, int subId, const QString& index)
{
  _id=id;
  _subId=subId;
  _index=index;
}

inline MetaDataIndex::MetaDataIndex(const MetaDataIndex& o)
{
  _id=o._id;
  _subId=o._subId;
  _index=o._index;
}

} // namespace GeopsyCore

#endif // METADATAINDEX_H
