/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-08-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYSIGNALHEADER_H
#define GEOPSYSIGNALHEADER_H

#include <QtCore>
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#define GEOPSYSIGNAL_TAG "GeopsySignal   "
#define GEOPSYSIGNAL_MAGICINT -2078964521
#define GEOPSYSIGNAL_MAGICFLOAT -333.3333333e33
#define GEOPSYSIGNAL_VERSION 3
#define GEOPSYSIGNAL_HEADERSIZE 16+8+5*4
#define GEOPSYSIGNAL_TRACEHEADERSIZE 20

#pragma pack(1)     // set alignment to 1 byte boundary

class GEOPSYCORE_EXPORT GeopsySignalHeader
{
public:
  bool isValid();

  union {
    char raw [GEOPSYSIGNAL_HEADERSIZE];
    struct {  // File header version 3
      char tag[16];
      double magicFloat;
      qint32 magicInt;
      qint32 version;
      qint32 offset;
      qint32 nSignals;
      qint32 traceHeaderSize;
    } field;
    struct {  // File header version 2
      char tag[16];
      double magicFloat;
      qint32 magicInt;
      qint32 version;
      qint32 offset;
      qint32 nSignals;
    } compat2;
    struct {  // File header version 1
      char tag[10];
      qint32 version;
      qint32 offset;
      qint32 nSignals;
    } compat1;
  };
};

class GEOPSYCORE_EXPORT GeopsySignalTraceHeader
{
public:
  bool isValid();

  union {
    char raw [GEOPSYSIGNAL_TRACEHEADERSIZE];
    struct {  // File header version 3
      double magicFloat; // versions < 3 do not have a trace header.
                         // Signal::loadGeopsySignal() had no information about
                         // file version. We do not want to add a header field
                         // in Signal structure or a MetaData to store the version if the file, instead
                         // the verion number is stored in trace header and available
                         // for Signal::loadGeopsySignal().
                         // magicFloat is mostly to recognize version 2 files, the probability
                         // that the first sample is the same value is very low. The number of
                         // version 2 files will decrease in the time, even reducing the risk of error.
                         // A correct version number is a supplemetary test for version 2 files.
      qint32 version;
      double unitPerCount;
    } field;
  };
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // GEOPSYSIGNALHEADER_H
