#ifndef GEOPSYCORE_HEADERS
#define GEOPSYCORE_HEADERS

// All headers of GeopsyCore library

#include "AbstractFileFormat.h"
#include "AbstractSignalGroup.h"
#include "AbstractSignalResults.h"
#include "AbstractTool.h"
#include "AsciiSignalFormat.h"
#include "AsciiSignalFormatComponent.h"
#include "AsciiSignalFormatReader.h"
#include "AsciiSignalFormatRule.h"
#include "CityScanner.h"
#include "CitySignal.h"
#include "Comments.h"
#include "CompatibilityTimeReference.h"
#include "ComplexSignal.h"
#include "CoreToolInterface.h"
#include "CustomFileFormats.h"
#include "DefaultSignalGroup.h"
#include "DeviceCardScanner.h"
#include "DoubleSignal.h"
#include "DuplicateRays.h"
#include "DynamicSignal.h"
#include "FFTWCache.h"
#include "FastFourierTransform.h"
#include "FilterParameters.h"
#include "FourierPlan.h"
#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"
#include "GeopsyCoreEngine.h"
#include "GeopsyCoreInterface.h"
#include "GeopsyPluginSettings.h"
#include "GeopsyPlugins.h"
#include "GeopsyPreferences.h"
#include "GeopsySignalHeader.h"
#include "Gse.h"
#include "GuralpCompressedBlock.h"
#include "GuralpRecords.h"
#include "GuralpSignal.h"
#include "InstrumentalResponse.h"
#include "KeepSignal.h"
#include "MasterSignalGroup.h"
#include "MetaData.h"
#include "MetaDataFactory.h"
#include "MetaDataField.h"
#include "MetaDataFieldList.h"
#include "MetaDataIndex.h"
#include "MetaDataMap.h"
#include "MiniSeedSequence.h"
#include "MorletParameters.h"
#include "NormalizationParameters.h"
#include "OriginalFileName.h"
#include "PasscalSegYHeader.h"
#include "RotateParameters.h"
#include "SACHeader.h"
#include "SEGDHeader.h"
#include "SEGYHeader.h"
#include "SEGYTraceHeader.h"
#include "SeismicEvent.h"
#include "SeismicEventTable.h"
#include "SharedMetaData.h"
#include "SharkHeader.h"
#include "SignalDatabase.h"
#include "SignalExpression.h"
#include "SignalExpressionContext.h"
#include "SignalFile.h"
#include "SignalFileFormat.h"
#include "SignalFilePool.h"
#include "SignalGroup.h"
#include "SignalGroupFactory.h"
#include "SignalGroupFolder.h"
#include "SignalHeaderScript.h"
#include "SignalProcess.h"
#include "SignalProcessObject.h"
#include "SignalProcessScript.h"
#include "SignalResultsFactory.h"
#include "SignalTemplate.h"
#include "SortKey.h"
#include "SparseKeepSignal.h"
#include "SparseTimeRange.h"
#include "StackCount.h"
#include "StationGroup.h"
#include "StationList.h"
#include "StationProcessSignals.h"
#include "StationSignals.h"
#include "SubSignalPool.h"
#include "SubSignalPoolProcess.h"
#include "SyscomHeader.h"
#include "SyscomSVmrxHeader.h"
#include "SyscomXmrHeader.h"
#include "TaperDelegate.h"
#include "TimePick.h"
#include "TimeRange.h"
#include "TimeRangeList.h"
#include "TimeRangeParameters.h"
#include "TimeWindow.h"
#include "TimeWindowList.h"
#include "WaveHeader.h"
#include "WindowingParameters.h"
#include "XMLSignal.h"
#include "XMLSubSignalPool.h"

#ifndef GP_EXPLICIT_LIBRARY_NAMESPACE
using namespace GeopsyCore;
#endif

#endif // GEOPSYCORE_HEADERS
