/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Comments.h"
#include "MetaDataFactory.h"

namespace GeopsyCore {

  /*!
    \class Comments Comments.h
    \brief Comments meta data for Signal

    Comments is an optional string attached to a Signal
  */

  REGISTER_METADATA(Comments)

  QStringList Comments::subNames() const
  {
    QStringList names;
    names << xmlCommentsTag;
    return names;
  }

  QString Comments::name(int, const QString&) const
  {
    return xmlCommentsTag;
  }

  QString Comments::baseName(int) const
  {
    return xmlCommentsTag;
  }

  QString Comments::title(int, const QString&) const
  {
    return tr("Comments");
  }

} // namespace GeopsyCore
