/***************************************************************************
**
**  This file is part of DinverGui.
**
**  DinverGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "ParamMinMaxWidget.h"

namespace DinverGui {

/*
 *  Constructs a ParamMinMaxWidget as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
ParamMinMaxWidget::ParamMinMaxWidget(QWidget *parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);

  on_pFixed_stateChanged(0);
}

/*
 *  Destroys the object and frees any allocated resources
 */
ParamMinMaxWidget::~ParamMinMaxWidget()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}

void ParamMinMaxWidget::on_pFixed_stateChanged(int)
{
  TRACE;
  if(pFixed->isChecked()) {
    pToLabel->hide();
    pMax->hide();
  } else {
    pToLabel->show();
    pMax->show();
  }
}

} // namespace DinverGui
