/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VALUETARGET_H
#define VALUETARGET_H

#include "Target.h"

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT ValueTarget : public Target
{
public:
  ValueTarget();
  ValueTarget(const ValueTarget& o);

  virtual const QString& xml_tagName() const {return xmlValueTargetTag;}
  static const QString xmlValueTargetTag;

  const RealStatisticalValue& value() const {return _value;}
  RealStatisticalValue& value() {return _value;}
  void setValue(const RealStatisticalValue& v) {_value=v;}
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  RealStatisticalValue _value;
};

} // namespace DinverDCCore

#endif // VALUETARGET_H
