/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MagnetoTelluricTarget.h"

namespace DinverDCCore {

  const QString MagnetoTelluricTarget::xmlMagnetoTelluricTargetTag="MagnetoTelluricTarget";

/*!
  \class MagnetoTelluricTarget MagnetoTelluricTarget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MagnetoTelluricTarget::MagnetoTelluricTarget()
    : Target()
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
MagnetoTelluricTarget::MagnetoTelluricTarget(const MagnetoTelluricTarget& o)
  : Target(o)
{
  TRACE;
  _curves=o._curves;
}

void MagnetoTelluricTarget::setCurves(const QList<MagnetoTelluricCurve>& c)
{
  TRACE;
  _curves=c;
  for(QList<MagnetoTelluricCurve>::iterator it=_curves.begin(); it!=_curves.end(); it++) {
    it->sort();
  }
}

void MagnetoTelluricTarget::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  for(QList<MagnetoTelluricCurve>::const_iterator it=_curves.begin(); it!=_curves.end(); ++it) {
    it->xml_save(s, context);
  }
}

XMLMember MagnetoTelluricTarget::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  if(tag=="MagnetoTelluricCurve") {
    _curves.append(MagnetoTelluricCurve());
    return XMLMember(&_curves.last());
  } else return Target::xml_member(tag, attributes, context);
}

} // namespace DinverDCCore
