/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-17
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ScaledModels.h"
#include "ActiveModels.h"
#include "VoronoiNavigator.h"

namespace DinverCore {

  /*!
    \class ScaledModels ScaledModels.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ScaledModels::ScaledModels(ActiveModels * m, double * scales)
  {
    _modelCount=m->count();
    // Keep number of dimensions
    _parameterCount=m->parameterCount();
    // Axis scales: Wathelet(2008), Voronoi geometry is not invariant against axis scaling
    // and it has a strong effect on exploration properties.
    _scales=scales;
    // Cache scaled squares of cells coordinates and scaled coordinates
    _v=new double *[_parameterCount];
    _v2=new double *[_parameterCount];
    for(int ip=0;ip<_parameterCount; ip++) {
      _v[ip]=new double[_modelCount];
      _v2[ip]=new double[_modelCount];
    }
    double tmp;
    for(int im=0; im<_modelCount; im++) {
      const int * v=m->model(im);
      for(int ip=0;ip<_parameterCount; ip++) {
        tmp=_scales[ip]*v[ip];
        _v[ip][im]=tmp;
        _v2[ip][im]=tmp*tmp;
      }
    }
  }

  /*!
    Description of constructor still missing
  */
  ScaledModels::ScaledModels(ModelSet * m, double * scales)
  {
    _modelCount=m->count();
    // Keep number of dimensions
    _parameterCount=m->parameterCount();
    // Axis scales: Wathelet(2008), Voronoi geometry is not invariant against axis scaling
    // and it has a strong effect on exploration properties.
    _scales=scales;
    // Cache scaled squares of cells coordinates and scaled coordinates
    _v=new double *[ _parameterCount ];
    _v2=new double *[ _parameterCount ];
    for(int ip=0;ip<_parameterCount; ip++) {
      _v[ip]=new double[ _modelCount ];
      _v2[ip]=new double[_modelCount  ];
    }
    double tmp;
    for(int im=0;im<_modelCount; im++) {
      const int * v=m->model(im);
      for(int ip=0;ip<_parameterCount; ip++) {
        tmp=_scales[ip] * v[ip];
        _v[ip][im]=tmp;
        _v2[ip][im]=tmp*tmp;
      }
    }
  }

  /*!
    Description of destructor still missing
  */
  ScaledModels::~ScaledModels()
  {
    TRACE;
    delete [] _scales;
    for(int i=0;i<_parameterCount;i++) {
      delete [] _v[i];
      delete [] _v2[i];
    }
    delete [] _v;
    delete [] _v2;
  }

} // namespace DinverCore
