/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-13
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEMODELS_H
#define ACTIVEMODELS_H

#include "DinverCoreDLLExport.h"
#include "ModelSet.h"
#include "ActiveModel.h"

namespace DinverCore {

class DINVERCORE_EXPORT ActiveModels : private IncreaseStorage
{
public:
  ActiveModels(ModelSet * allModels);
  ~ActiveModels();

  inline ActiveModel& add(int modelIndex);
  inline ActiveModel& add(const ActiveModel& m);
  void clear();
  void addNavigatorHits(const QVector<int>& activeIndexes);
  void setNavigatorHits(const QVector<int>& activeIndexes);

  void reserve(int n) {IncreaseStorage::reserve(n);}
  int count() const {return IncreaseStorage::size();}
  int parameterCount() const {return _allModels->parameterCount();}
  int targetCount() const {return _allModels->targetCount();}
  ModelSet * allModels() const {return _allModels;}

  ActiveModel& at(int activeIndex) {return _infos[ activeIndex ];}
  const ActiveModel& at(int activeIndex) const {return _infos[ activeIndex ];}

  inline const double * misfit(int activeIndex) const;
  //inline double volume(int activeIndex) const;
  inline const int * model(int activeIndex) const;

  void print(int activeIndex);
private:
  virtual void reallocate();

  ModelSet * _allModels;
  ActiveModel * _infos;
};

inline ActiveModel& ActiveModels::add(int modelIndex)
{
  _infos[size()]=modelIndex;
  IncreaseStorage::add();
  return _infos[size()-1]; // reallocate possible with add
}

inline ActiveModel& ActiveModels::add(const ActiveModel& m)
{
  _infos[size()]=m;
  IncreaseStorage::add();
  return _infos[size()-1]; // reallocate possible with add
}

inline const double * ActiveModels::misfit(int activeIndex) const
{
  return _allModels->misfit(_infos[ activeIndex ].modelIndex());
}

/*inline double ActiveModels::volume(int activeIndex) const
{
  return _models->volume(_infos[ activeIndex ].modelIndex());
}*/

inline const int * ActiveModels::model(int activeIndex) const
{
  return _allModels->model(_infos[ activeIndex ].modelIndex());
}

} // namespace DinverCore

#endif // ACTIVEMODELS_H
