/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-04
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACCROSSSPECTRUM_H
#define SPACCROSSSPECTRUM_H

#include "ArrayCrossSpectrum.h"
#include "StationPairs.h"
#include "SPACParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SPACCrossSpectrum : public ArrayCrossSpectrum
  {
  public:
    SPACCrossSpectrum(const ArraySelection * array,
                      const SPACParameters * param);
    ~SPACCrossSpectrum();

    const SPACParameters * parameters() const {return static_cast<const SPACParameters *>(_parameters);}

    int stationPairCount() const {return _stationPairs.count();}
    const StationPair& stationPair(int index) const {return _stationPairs.at(index);}
    const QVector<StationPair>& stationPairs() const {return _stationPairs;}

    int ringCount() const {return _rings.count();}
    const RingPairs& ring(int index) {return _rings.at(index);}

    bool calculate(const QVector<int>& blocks);

    inline const ComplexMatrix& verticalCrossSpectrum() const;
    inline const ComplexMatrix& horizontalCrossSpectrum() const;
  private:
    void setStationPairs(const ArraySelection * array);
    void setRings();
    void normalize(ComplexMatrix& covmat);
    void resize();

    StationPairs _stationPairs;
    QVector<RingPairs> _rings;
  };

  inline const ComplexMatrix& SPACCrossSpectrum::verticalCrossSpectrum() const
  {
    return ArrayCrossSpectrum::rayleigh();
  }

  inline const ComplexMatrix& SPACCrossSpectrum::horizontalCrossSpectrum() const
  {
    return ArrayCrossSpectrum::love();
  }

} // namespace ArrayCore

#endif // SPACCROSSSPECTRUM_H
