/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-02-02
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKRAYLEIGHELLIPTICITY_H
#define HRFKRAYLEIGHELLIPTICITY_H

#include "HRFKRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKRayleighEllipticity : public HRFKRayleigh
  {
  public:
    HRFKRayleighEllipticity(FKCache * cache);

    void setK(const Point2D& k) {_k=k;}
    void setCrossSpectrum(const ComplexMatrix * crossSpectrum) {_crossSpectrum=crossSpectrum;}

    virtual bool initGrid(int) {return false;}

    virtual double value(const Point& ell, int) const {return value(ell);}
    virtual double value(const Point&) const {return 0.0;}
  protected:
    Point2D _k;
    const ComplexMatrix * _crossSpectrum;
  };

  class ARRAYCORE_EXPORT HRFKRayleighRadialEllipticity : public HRFKRayleighEllipticity
  {
  public:
    HRFKRayleighRadialEllipticity(FKCache * cache)
      : HRFKRayleighEllipticity(cache) {}

    virtual double value(const Point& ell) const;
  };

  class ARRAYCORE_EXPORT HRFKRayleighVerticalEllipticity : public HRFKRayleighEllipticity
  {
  public:
    HRFKRayleighVerticalEllipticity(FKCache * cache)
      : HRFKRayleighEllipticity(cache) {}

    virtual double value(const Point& ell) const;
  };

  class ARRAYCORE_EXPORT HRFKDirectRayleighEllipticity : public HRFKRayleighEllipticity
  {
  public:
    HRFKDirectRayleighEllipticity(FKCache * cache);
  };

  class ARRAYCORE_EXPORT HRFKDirectRayleighRadialEllipticity : public HRFKDirectRayleighEllipticity
  {
  public:
    HRFKDirectRayleighRadialEllipticity(FKCache * cache)
      : HRFKDirectRayleighEllipticity(cache) {}

    virtual double value(const Point& ell) const;
  };

  class ARRAYCORE_EXPORT HRFKDirectRayleighVerticalEllipticity : public HRFKDirectRayleighEllipticity
  {
  public:
    HRFKDirectRayleighVerticalEllipticity(FKCache * cache)
      : HRFKDirectRayleighEllipticity(cache) {}

    virtual double value(const Point& ell) const;
  };

} // namespace ArrayCore

#endif // HRFKRAYLEIGHELLIPTICITY_H

