/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-11-17
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKRAYLEIGH_H
#define HRFKRAYLEIGH_H

#include "ConvFKRayleigh.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKRayleigh : public ConvFKRayleigh
  {
  public:
    HRFKRayleigh(FKCache * gridCache);

    bool invertCrossSpectrum();

    virtual void setGrid(FKGridSearch * g, double step, double size);
    virtual bool initGrid(int n);
    virtual void initGrid(const Point& kell, int index);

    virtual double value(const Point& kell, int index) const;
    virtual double value(const Point& kell) const;

    virtual bool hasEllipticity() const {return true;}
    virtual double ellipticity(const Point& kell);
    virtual double noise(const Point& kell) const;
    virtual double power(double optimumPower) const;

    virtual double thirdMinimum() const {return -0.5*M_PI;}
    virtual double thirdMaximum() const {return 0.5*M_PI;}
    virtual double thirdStep() const {return M_PI/90;}
  protected:
    double adjustEllipticity(double ellh, double ellz);

    double _RoverN;
    double _ellipticity;
  };

} // namespace ArrayCore

#endif // HRFKRAYLEIGH_H

