/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-02-14
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKTOOL_H
#define FKTOOL_H

#include "AbstractArrayTool.h"
#include "FKTaskManager.h"
#include "FKResults.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class KmaxSolver;

  class ARRAYCORE_EXPORT FKTool : public AbstractArrayTool
  {
    Q_OBJECT
  public:
    FKTool();
    ~FKTool();

    virtual bool setSubPool(SubSignalPool *subPool);
    bool setParameters(const AbstractParameters& param);
    inline const FKParameters * parameters() const;
    inline FKParameters * parameters();

    virtual bool setWaveNumberGrid();

    FKResults * results() const {return static_cast<FKResults *>(AbstractArrayTool::results());}
    virtual void waitFinished();
    bool isWaveNumberGridReady() const {return !_kmaxSolver;}
  protected:
    virtual QString toolName() {return tr("FK Array analysis");}
    virtual TaskManager * createLoop() {return new FKTaskManager(array());}
  public slots:
    void start();
  signals:
    void waveNumberGridReady();
  private slots:
    void setComputedKmax(KmaxSolver * solver=nullptr);
  private:
    KmaxSolver * _kmaxSolver;
  };

  inline const FKParameters * FKTool::parameters() const
  {
    return static_cast<const FKParameters *>(AbstractArrayTool::parameters());
  }

  inline FKParameters * FKTool::parameters()
  {
    return static_cast<FKParameters *>(AbstractArrayTool::parameters());
  }

} // namespace ArrayCore

#endif // FKTOOL_H

