/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-12
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "AsyncParameters.h"

namespace ArrayCore {

  /*!
    \class AsyncParameters AsyncParameters.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  AsyncParameters::AsyncParameters()
  {
    _damping=0.0;
  }

  AsyncParameters::AsyncParameters(const AsyncParameters& o)
    : FKParameters(o), _blockAveraging(o._blockAveraging)
  {
    _damping=o._damping;
  }

  int AsyncParameters::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
  {
    return 1+FKParameters::keywordCount();
  }

  int AsyncParameters::totalKeywordCount(PARAMETERS_TOTALKEYWORDCOUNT_ARGS) const
  {
    return FKParameters::totalKeywordCount()+
        _blockAveraging.totalKeywordCount();
  }

  void AsyncParameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
  {
    TRACE;
    int baseIndex=FKParameters::keywordCount();
    FKParameters::collectKeywords(keywords, prefix, suffix);
    keywords.add(prefix+"DAMPING_FACTOR"+suffix, this, baseIndex);
    _blockAveraging.collectKeywords(keywords, prefix, suffix);
  }

  QString AsyncParameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
  {
    TRACE;
    QString log;
    log+=_blockAveraging.toString(prefix, suffix);
    log+=FKParameters::toString(prefix);
    log+=prefix+"DAMPING_FACTOR"+suffix+"="+QString::number(_damping)+"\n";
    return log;
  }

  bool AsyncParameters::setValue(PARAMETERS_SETVALUE_ARGS)
  {
    TRACE;
    switch(index-FKParameters::keywordCount()) {
    case 0:
      if(_damping>=0.0) {
        _damping=value.toDouble();
      }
      return true;
    default:
      break;
    }
    return FKParameters::setValue(index, value, unit, keywords);
  }

} // namespace ArrayCore

