/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-10
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "AsyncFKLoop.h"
#include "AsyncArrayProcess.h"
#include "ArrayStationSignals.h"

namespace ArrayCore {
#if 0
  /*!
    \class AsyncFKLoop AsyncFKLoop.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  AsyncFKLoop::AsyncFKLoop(const ArraySelection * array)
    : FKLoop(array)
  {
    TRACE;
  }

  LoopWorker * AsyncFKLoop::newWorker()
  {
    TRACE;
    AsyncFKLoopWorker * t=new AsyncFKLoopWorker;
    t->setLoop(this);
    t->setArray(array());
    t->setParameters(parameters());
    t->setGrid(_gridCache);
    return t;
  }

  void AsyncFKLoopWorker::setArray(const ArraySelection * array)
  {
    TRACE;
    _process=new AsyncArrayProcess(array);
    //_crossSpectrum->setTimeRangeList(new TimeWindowList);
  }

  void AsyncFKLoopWorker::run(int index)
  {
    TRACE;
    AsyncArrayProcess * p=static_cast<AsyncArrayProcess *>(_process);
    int iOmega=endIndex()-index-1;
    p->setFrequency(p->parameters()->frequencySampling().value(iOmega));
    p->crossSpectrum();
  }
#endif
} // namespace ArrayCore

