/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-10-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEHRFKRAYLEIGHELLIPTICITY_H
#define ACTIVEHRFKRAYLEIGHELLIPTICITY_H

#include "ActiveHRFKRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveHRFKRayleighEllipticity : public ActiveHRFKRayleigh
  {
  public:
    ActiveHRFKRayleighEllipticity(FKCache * gridCache)
      : ActiveHRFKRayleigh(gridCache) {_crossSpectrum=nullptr;}

    void setK(double k) {_k=k;}
    void setCrossSpectrum(const ComplexMatrix * crossSpectrum) {_crossSpectrum=crossSpectrum;}

    void setGrid(FKGridSearch * g, double step, double size);

    virtual double value(const Point&) const {return 0.0;}
  protected:
    double _k;
    const ComplexMatrix * _crossSpectrum;
  };

  class ARRAYCORE_EXPORT ActiveHRFKRayleighRadialEllipticity : public ActiveHRFKRayleighEllipticity
  {
  public:
    ActiveHRFKRayleighRadialEllipticity(FKCache * gridCache)
      : ActiveHRFKRayleighEllipticity(gridCache) {}

    virtual double value(const Point& ell) const;
  };

  class ARRAYCORE_EXPORT ActiveHRFKRayleighVerticalEllipticity : public ActiveHRFKRayleighEllipticity
  {
  public:
    ActiveHRFKRayleighVerticalEllipticity(FKCache * gridCache)
      : ActiveHRFKRayleighEllipticity(gridCache) {}

    virtual double value(const Point& ell) const;
  };

  class ARRAYCORE_EXPORT ActiveConvFKRayleighRadialEllipticity : public ActiveHRFKRayleighEllipticity
  {
  public:
    ActiveConvFKRayleighRadialEllipticity(FKCache * gridCache)
      : ActiveHRFKRayleighEllipticity(gridCache) {}

    virtual double value(const Point& ell) const;
  };

  class ARRAYCORE_EXPORT ActiveConvFKRayleighVerticalEllipticity : public ActiveHRFKRayleighEllipticity
  {
  public:
    ActiveConvFKRayleighVerticalEllipticity(FKCache * gridCache)
      : ActiveHRFKRayleighEllipticity(gridCache) {}

    virtual double value(const Point& ell) const;
  };

} // namespace ArrayCore

#endif // ACTIVEHRFKRAYLEIGHELLIPTICITY_H

