/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-03-13
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTARRAYRESULTS_H
#define ABSTRACTARRAYRESULTS_H

#include <QGpCoreMath.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ArrayParameters;
  class ArraySelection;

  class ARRAYCORE_EXPORT AbstractArrayResults
  {
  public:
    AbstractArrayResults();
    virtual ~AbstractArrayResults();

    void setParameters(const ArrayParameters * param) {_parameters=param;}
    virtual void setArray(const ArraySelection * array) {_array=array;}
    virtual void clear()=0;
  protected:
    const ArrayParameters * _parameters;
    const ArraySelection * _array;
  };

} // namespace ArrayCore

#endif // ABSTRACTARRAYRESULTS_H

