/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALVIEWER_H
#define SIGNALVIEWER_H

#include <GeopsyGui.h>

class SignalViewer : public AxisWindow
{
  Q_OBJECT
public:
  SignalViewer(QWidget * parent);
  ~SignalViewer();

  void setSignals(SubSignalPool * subPool);
  void setMaximumTime(const DateTime& t);
  void setDisplayRange(double l);

  void lock();
  void unlock();
private:
  SignalLayer * _signalLayer;
};

#endif // SIGNALVIEWER_H
