/***************************************************************************
**
**  This file is part of vslarray.
**
**  vslarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  vslarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-24
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACQUISITION_H
#define ACQUISITION_H

#include <ArrayCore.h>
#include <QGpCoreTools.h>

class AcquisitionSignals;

class Acquisition : public Thread
{
  Q_OBJECT
public:
  Acquisition(double timeScale=1.0);
  ~Acquisition();

  bool setSignals(SubSignalPool subPool);
  void setDelay(double d) {_delay=fabs(d);}

  static bool setDestination(QString destDir);
  static const QDir& destination() {return _destDir;}

  void stop();
  void status();
  void startStations(QString stationList);
  void stopStations(QString stationList);
private slots:
  void mainLoop();
protected:
  virtual void run();
private:
  double _delay;
  double _timeScale;
  static QDir _destDir;
  ArrayStations _array;
  QList<AcquisitionSignals *> _stations;
  QTimer * _globalTimer;
  TimeRange _globalTimeWindow;
};

#endif // ACQUISITION_H
