/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HistogramsWidget.h"
#include "ModeWidgets.h"

/*!
  \class HistogramsWidget HistogramsWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
HistogramsWidget::HistogramsWidget(QWidget * parent)
  : GraphicSheetMenu(parent)
{
  TRACE;
  Settings::getWidget(this, "Histogram");

  _normalize=true;
}

/*!
  Description of destructor still missing
*/
HistogramsWidget::~HistogramsWidget()
{
  TRACE;
}

void HistogramsWidget::closeEvent(QCloseEvent * e)
{
  TRACE;
  Settings::setWidget(this, "Histogram");
  e->accept();
}

void HistogramsWidget::setSamples(const Samples& s, const Reader& param)
{
  TRACE;
  ModeWidgets * w=new ModeWidgets(this);
  _modes.append(w);

  w->addWidgets(sheet(), param);
  w->setSamples(s, param);
  w->setLimits(_normalize);
}

void HistogramsWidget::setHistogramComments(QString cmt)
{
  TRACE;
  for(QList<ModeWidgets *>::iterator it=_modes.begin(); it!=_modes.end(); it++) {
    (*it)->setComments(cmt);
  }
}

bool HistogramsWidget::splitModes(const Samples& s, const Reader& param)
{
  TRACE;
  if(param.curveFileNames().isEmpty()) {
    return true;
  }
  DispersionProxy proxy;
  ColumnTextParser parser;
  parser.setStandardTypes(proxy.columnFileTypes());
  if(param.curveFormatFileName().isEmpty()) {
    parser.setTypes(proxy.defaultColumnFileTypes());
  } else {
    XMLHeader hdr(&parser);
    if(hdr.xml_restoreFile(param.curveFormatFileName())!=XMLClass::NoError) {
      return false;
    }
  }
  QStringList expandedFileNames=File::expand(param.curveFileNames());
  for(QStringList::const_iterator itf=expandedFileNames.begin(); itf!=expandedFileNames.end(); itf++) {
    QFile f(*itf);
    QFileInfo fi(*itf);
    if(f.open(QIODevice::ReadOnly)) {
      parser.setText(new QTextStream(&f));
      parser.start();
      parser.wait();
      ColumnTextIterator it(&parser);
      int curveNumber=0;
      while(!it.atEnd()) {
        ModalCurve c;
        proxy.setCurve(&c);
        if(!proxy.parse(it)) {
          return false;
        }
        c.setName(fi.fileName()+"#"+QString::number(++curveNumber));
        Samples * newSamples=s.filterCurve(c, param.relativeRange());
        Samples * filtSamples=newSamples->filterNoiseSmart(param.noiseDeviation(),
                                                           param.slownessDeviation());
        if(filtSamples) {
          delete newSamples;
          newSamples=filtSamples;
        }
        setSamples(*newSamples, param);
        delete newSamples;
      }
    } else {
      App::log(tr("Cannot open file '%1'\n").arg(*itf));
      return false;
    }
  }
  return true;
}


void HistogramsWidget::exportPlot(const ExportOptions& o)
{
  TRACE;
  if(!o.colorMapFile().isEmpty()) {
    ColorMap pal;
    XMLErrorReport xmler(XMLErrorReport::Read | XMLErrorReport::NoMessageBox);
    xmler.setTitle(tr("Load palette"));
    xmler.setFileName(o.colorMapFile());
    XMLSciFigs s;
    if(xmler.exec(s.restoreFile(o.colorMapFile(), &pal, XMLSciFigs::Data))) {
      for(QList<ModeWidgets *>::iterator it=_modes.begin(); it!=_modes.end(); it++) {
        (*it)->setColorMap(pal);
      }
    }
  }
  /* TODO add a mecanism to select which graph to add layers
  if(!o.appendLayerFiles().isEmpty()) {
    for(QStringList::const_iterator it=o.appendLayerFiles().begin(); it!=o.appendLayerFiles().end(); it++) {
      w->graphContent()->appendLayers(*it);
    }
  }
  if(!o.prependLayerFiles().isEmpty()) {
    for(QStringList::const_iterator it=o.prependLayerFiles().begin(); it!=o.prependLayerFiles().end(); it++) {
      w->graphContent()->prependLayers(*it);
    }
  }*/
  foreach(QString m, o.makeupObjectFiles()) {
    _sheet.restoreMakeUp(m);
  }
  if(!o.preserveScales()) {
    for(QList<ModeWidgets *>::iterator it=_modes.begin(); it!=_modes.end(); it++) {
      (*it)->setLimits(_normalize);
    }
  }
  if(!o.exportFile().isEmpty()) {
    _sheet.exportFile(o.exportFile(), o.exportFormat(), o.dpi());
  }
}
