/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include <QGpGuiTools.h>

#include "LiveModelReader.h"
#include "gplivemodelVersion.h"
#include "gplivemodelInstallPath.h"

PACKAGE_INFO("gplivemodel", GPLIVEMODEL)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  Application a(argc, argv, help);
  SciFigsGlobal s;

  LiveModelReader reader;
  if(reader.setOptions(argc, argv) ) {
    return reader.exec();
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE1 [FILE2...]]" );
  h->setComments( "Compute various curves from input models in a graphical user interface. Models can be interactively "
                  "modified. For the background, a collection of models can be provided through stdin (option '-stdin') or FILEs.\n\n"
                  +GeophysicalModel::allFormatHelp()+
                 "Any number of models can be given as input.");
  h->addGroup("Curve type", "type");
  h->addOption("-disp","Sets to dipersion curve mode (default)");
  h->addOption("-disp-grid","Set to dipersion grid mode");
  h->addOption("-ell","Sets to ellipticity curve mode");
  h->addOption("-sh","Sets to Sh amplification curve mode");
  h->addOption("-mt","Sets to magneto-telluric curve mode");
  h->addGroup("X sampling", "xSampling");
  h->addOption("-n <count>","Number of frequency samples (default=100)");
  h->addOption("-min <min>","Minimum of range for x axis (default=0.2)");
  h->addOption("-max <max>","Maximum of range for x axis (default=20)");
  h->addOption("-s <sampling>","Defines the sampling type:\n"
                              "  period     regular sampling in period\n"
                              "  frequency  regular sampling in frequency\n"
                              "  log        regular sampling in log(frequency) (default)");
  h->addGroup("Dispersion curve", "dispCurve");
  h->addOption("-L <n modes>","Number of Love modes (default=0)");
  h->addOption("-R <n modes>","Number of Rayleigh modes (default=1)");
  h->addOption("-group","Switches to group slowness (default=phase)");
  h->addGroup("Dispersion grid", "dispGrid");
  h->addOption("-grid <L | R>","In -disp-grid mode, select Love or Rayleigh (default=R).");
  h->addOption("-vmin <min>","Minimum of range for velocity (only for -disp-grid, default=100)");
  h->addOption("-vmax <max>","Maximum of range for velocity (only for -disp-grid, default=1000)");
  h->addGroup("Ellitpticity curve", "ellCurve");
  h->addOption("-R <n modes>","Number of Rayleigh modes (default=1)");
  h->addOption("-abs","Output abs(ellipticities).");
  h->addOption("-angle","Output atan(ellipticity) in deg.");
  h->addOption("-angle-deg","Output atan(ellipticity) in deg.");
  h->addOption("-angle-rad","Output atan(ellipticity) in rad.");
  h->addGroup("Miscellaneous", "misc");
  h->addOption("-panel <PANEL>","Loads a pre-defined control panel");
  h->addOption("-scan-count <COUNT>","Set the number of steps for option 'scan' (default=10)");
  h->addOption("-scan <SLIDER>","Scans the slider which name is 'SLIDER'. Parameter p "
                                "is changed from 0 to 1 with COUNT steps (option 'scan-count'). The reference "
                                "model is the first background model (option 'stdin' is turned on). "
                                "The results are output to stdout and no graphical interface is started.");
  h->addOption("-stdin","Reads background models through stdin");
  return h;
}
