/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-16
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include <SciFigs.h>
#include "DispersionThread.h"
#include "DispersionThread.h"

/*!
  \class DispersionThread DispersionThread.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
DispersionThread::DispersionThread(QObject * parent)
    : Seismic1DThread(parent)
{
  TRACE;
  _nRayleigh=1;
  _nLove=0;
  _slowness=Mode::Phase;
}

/*!
  Description of constructor still missing
*/
DispersionThread::DispersionThread(const DispersionThread& o)
    : Seismic1DThread(o)
{
  TRACE;
  _nRayleigh=o._nRayleigh;
  _nLove=o._nLove;
  _slowness=o._slowness;
}

/*!
  Description of destructor still missing
*/
DispersionThread::~DispersionThread()
{
  TRACE;
}

void DispersionThread::initResultsGraphs(GraphicSheet * sheet)
{
  TRACE;
  CurvesThread::initResultsGraphs(sheet);
  AxisWindow * w=_layer->graph();
  w->xAxis()->setFrequency();
  w->yAxis()->setTitle(tr("Slowness (s/m)"));
  w->yAxis()->setTitleInversedScale(tr("Velocity (m/s)"));
}

bool DispersionThread::setParameters(int& argc, char ** argv)
{
  TRACE;
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-R") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _nRayleigh=atoi(argv[i]);
      } else if(arg=="-L") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _nLove=atoi(argv[i]);
      } else if(arg=="-group") {
        _slowness=Mode::Group;
      } else {
        argv[j++]=argv[i];
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  return CurvesThread::setParameters(argc, argv);
}

void DispersionThread::run(GeophysicalModel * m)
{
  if(_nRayleigh>0) {
    Rayleigh rayleigh(static_cast<Seismic1DModel *>(m));
    Dispersion dispersion (_nRayleigh, &_x);
    if(!dispersion.calculate(&rayleigh, 0, &_terminated)) {
      return;
    }
    if(_slowness==Mode::Group) {
      dispersion.setGroupSlowness();
    }
    for(int i=0;i<_nRayleigh;i++) {
      _curves.append(dispersion.curve(i));
    }
  }
  if(_nLove>0) {
    Love love(static_cast<Seismic1DModel *>(m));
    Dispersion dispersion (_nLove, &_x);
    if(!dispersion.calculate(&love, &_terminated)) return;
    if(_slowness==Mode::Group) {
      dispersion.setGroupSlowness();
    }
    for(int i=0;i<_nLove;i++) {
      _curves.append(dispersion.curve(i));
    }
  }
}
