/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-03-15
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPECTRUMSUMMARY_H
#define SPECTRUMSUMMARY_H

#include <HVGui.h>

class SpectrumSummary : public AbstractSummary
{
public:
  SpectrumSummary(QWidget* parent=0);
  ~SpectrumSummary();

  virtual void setWindowTitle(QString subPoolName);
protected:
  virtual void createGraphs(bool multiStations);
  virtual void setValues(const QMap<double, CurveResults *> * dist2stat=0);
};

#endif // SPECTRUMSUMMARY_H
