/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>
#include "HVSummary.h"

/*!
  \class HVSummary HVSummary.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
HVSummary::HVSummary(QWidget* parent)
    : AbstractSummary(parent)
{
  TRACE;
  Settings::getSize(this, "HVSummary");
}

/*!
  Description of destructor still missing
*/
HVSummary::~HVSummary()
{
  TRACE;
  Settings::setSize(this, "HVSummary");
}

void HVSummary::setWindowTitle(QString subPoolName)
{
  TRACE;
  QWidget::setWindowTitle(tr("H/V summary - ")+subPoolName);
}

void HVSummary::createGraphs(bool multiStations)
{
  TRACE;
  if(multiStations) {
    createStackedGraph(0.5, 0.0);
    createAverageGraph(9.5, 0.0);
    createSpectrumGridGraph(0.5, sheet()->printBottom());
    createBubbleGraph(0.5, sheet()->printBottom());
  } else {
    createStackedGraph(0.5, 0.0);
    createAverageGraph(9.5, 0.0);
  }
  setValueTitle(tr("H/V"));
}

void HVSummary::setValues(const QMap<double, CurveResults *> * dist2stat)
{
  TRACE;
  setStackedValues();
  setAverageValues();
  setAveragePeak();
  if(spectrumGridLayer()) {
    setSpectrumGridValues(dist2stat);
    setBubbleValues();
  }
}
