/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "HVRotateToolWidget.h"
#include "HVRotateStation.h"
#include "HVRotateResultSheet.h"

/*!
  \class HVRotateToolWidget HVRotateToolWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
HVRotateToolWidget::HVRotateToolWidget(QWidget * parent)
    : AbstractHVWidget(parent)
{
  TRACE;
  setWindowIcon(QIcon( ":hvrotate-22x22.png"));
  setObjectName("HVRotateToolWidget");

  winParam->addComponent(tr("Vertical"));
  winParam->addComponent(tr("North"));
  winParam->addComponent(tr("East"));

  removeHorizontalComponents();

  _tool=new HVRotateTool(this);
}

bool HVRotateToolWidget::setSubPool(SubSignalPool * subPool)
{
  TRACE;
  if(!AbstractHVWidget::setSubPool(subPool)) {
    return false;
  }
  setWindowTitle(tr("H/V Rotate toolbox - ")+subPool->name());
  return true;
}

AbstractResultSheet * HVRotateToolWidget::createResultSheet()
{
  TRACE;
  return new HVRotateResultSheet;
}

AbstractSummary * HVRotateToolWidget::createSummary()
{
  TRACE;
  return nullptr;
}
