/***************************************************************************
**
**  This file is part of geopsyarray.
**
**  geopsyarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-09
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACTOOLWIDGET_H
#define SPACTOOLWIDGET_H

#include <ArrayCore.h>
#include <GeopsyGui.h>

#include "ui_SPACToolWidget.h"

class SPACToolWidget :  public AbstractToolWidget, protected Ui::SPACToolWidget
{
  Q_OBJECT
public:
  SPACToolWidget(QWidget * parent);
  ~SPACToolWidget();

  virtual bool setSubPool(SubSignalPool * subPool);

  SPACTool * tool() {return static_cast<SPACTool *>(_tool);}
public slots:
  virtual void start();
  void stop();
protected slots:
  void parametersChanged();
  void finish();
private slots:
  void on_freqScroll_valueChanged(int);
  void numFreqChanged();
  void on_outputFileNameBrowse_clicked();
  void on_outputFileNameEdit_textChanged(QString);
protected:
  QString outputFileName();

  void setTimeWindowLayer(TimeWindowList * winList);
  void setRunning(bool r, const QString& message=QString());
  virtual void updateAllFields();

  void getParameters(SPACParameters& param) const;
  void setParameters(const SPACParameters& param);
  virtual AbstractParameters * parameters(AbstractParameters *param=0) const;
  virtual void setParameters(const AbstractParameters * param);

  void setArrayMap();
  void setCoArrayMap();
private:
  bool _outputFileChecked;

  TimeWindowList _winList;
};

#endif
