/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-08-30
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "SignalDisplay.h"
#include "GraphicWindow.h"
#include "MainWindow.h"

/*!
  Set receiver coordinate that need a refresh of lateral axes
*/
void SignalDisplay::setProperty(uint wid, int pid, QVariant val)
{
  TRACE;
  if(wid==_tab) {
    AxisWindow * plot=graph();
    GraphicWindow * win=static_cast<GraphicWindow* >(plot->parent());
    switch(pid) {
    case SignalsProperties::YAxis: {
        YAxis newYAxis=SignalsProperties::item2yAxis(val.toInt());
        if(yAxis()!=newYAxis) {
          setYAxis(newYAxis);
          subPoolUpdate(const_cast<SubSignalPool *>(subPool()));
          // Update labels before limits, particularly due to autoTicks and autoPrecision
          win->updateLabels();
          win->setLimits();
          plot->updateInternalGeometry();
          plot->update();
        }
        return;
      }
    case SignalsProperties::Overlap:
      setOverlap(val.toDouble());
      if(baseLineCount()==1) {
        win->setLimits();
        plot->updateInternalGeometry();
        plot->update();
      } else {
        plot->deepUpdate();
      }
      return;
    case SignalsProperties::TimeScale: {
        TimeScale newTimeScale=SignalsProperties::item2timeScale(val.toInt());
        if(timeScale()!=newTimeScale) {
          setTimeScale(newTimeScale);
          win->updateLabels();
          win->setLimits();
          plot->updateInternalGeometry();
          plot->update();
        }
      }
      return;
    default:
      break;
    }
  }
  SignalLayer::setProperty(wid, pid, val);
}
