/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GeopsyAbout.h"
#include "GeopsyAboutDialog.h"

/*!
  Constructs a GeopsyAboutDialog as a child of 'parent', with the
  name 'name' and widget flags set to 'f'.

  The dialog will by default be modeless, unless you set 'modal' to
  true to construct a modal dialog.
*/
GeopsyAboutDialog::GeopsyAboutDialog(QWidget *parent, Qt::WindowFlags f)
    : Dialog(parent, f)
{
  TRACE;
  QVBoxLayout * vboxLayout=new QVBoxLayout(this);

  GeopsyAbout * geopsyAbout=new GeopsyAbout(this);
  vboxLayout->addWidget(geopsyAbout);

  QHBoxLayout * hboxLayout=new QHBoxLayout();
  hboxLayout->setMargin(0);
  QSpacerItem * spacerItem=new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
  hboxLayout->addItem(spacerItem);

  QPushButton * pushButton=new QPushButton(this);
  hboxLayout->addWidget(pushButton);

  spacerItem=new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
  hboxLayout->addItem(spacerItem);

  vboxLayout->addLayout(hboxLayout);

  setWindowTitle(tr("About GEOPSY"));
  pushButton->setText(tr("Close"));
  connect(pushButton,SIGNAL(clicked()), this, SLOT(close()));
}

/*
 *  Destroys the object and frees any allocated resources
 */
GeopsyAboutDialog::~GeopsyAboutDialog()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}

