/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-03-21
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CUSTOMASCIIFORMATSEDITOR_H
#define CUSTOMASCIIFORMATSEDITOR_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "ui_CustomAsciiFormatsEditor.h"

class CustomAsciiFormatsEditor : public Dialog, private Ui::CustomAsciiFormatsEditor
{
  Q_OBJECT
public:
  CustomAsciiFormatsEditor(QWidget * parent=nullptr);
  ~CustomAsciiFormatsEditor();
private slots:
  void selectionChanged();
  void on_newButton_clicked();
  void on_editButton_clicked();
  void on_removeButton_clicked();
  void on_importButton_clicked();
  void on_exportButton_clicked();
private:
  void updateList();

  CustomFileFormats * _formats;
};

#endif // CUSTOMASCIIFORMATSEDITOR_H
