/***************************************************************************
**
**  This file is part of dinverext.
**
**  dinverext is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverext is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef EXTPLUGIN_H
#define EXTPLUGIN_H

#include <QObject>

#include <DinverGui.h>

#include "dinverextInstallPath.h"

class ExtTargetWidget;
class ExtTarget;
class ExtInversion;

class ExtPlugin : public DinverInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.dinverInterface")
#endif
  Q_INTERFACES(DinverCore::DinverInterface)
public:
  ExtPlugin();
  ~ExtPlugin();

  virtual DinverInterface * clone();

  virtual QString tag() const;
  virtual QString title() const ;
  virtual QString version() const ;
  virtual QString description() const ;

  virtual QWidget * createTargetWidget();
  virtual QWidget * createParamWidget();

  virtual bool xmlSupport() const {return true;}
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polishChild(XML_POLISHCHILD_ARGS);
  virtual const char * interfaceVersion() const {return DINVERCORE_VERSION;}

  virtual AbstractForward * createForward();
  virtual bool initForward(AbstractForward * forward);
  virtual void setCurrentForward(AbstractForward * forwards, const QString& );
private slots:
  void checkScript();
private:
  ParamSpaceEditor * _paramWidget;
  ExtTargetWidget * _targetWidget;
  // Global and batch definition of parameters and target
  // Null when global selection is active
  ParamSpaceScript * _param;
  ExtTarget * _target;
};

#endif // EXTPLUGIN_H
