/***************************************************************************
**
**  This file is part of campbelltob3.
**
**  campbelltob3 is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  campbelltob3 is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-18
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Plugin.h"
#include "CampbellLoader.h"

#include "campbelltob3InstallPath.h"
#include "campbelltob3Version.h"
#include "GeopsyCoreVersion.h"

/*!
  \class Plugin Plugin.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const char * Plugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

QList<QAction*> Plugin::createImportActions(QWidget * parent) const
{
  TRACE;
  QList<QAction*> actions;
  QAction * a;

  a=new QAction(parent);
  a->setText(tr("Campbell TOB3"));
  connect(a, SIGNAL(triggered()), this, SLOT(import()));
  actions.append(a);
  return actions;
}

void Plugin::import()
{
  TRACE;
  QAction * a=qobject_cast<QAction *>(sender());
  if(a) {
    QWidget * parent=qobject_cast<QWidget *>(a->parent());
    if(parent) {
      CampbellLoader * d=new CampbellLoader(parent);
      Settings::getWidget(d);
      d->scan();
      d->exec();
      Settings::setWidget(d);
      delete d;
    }
  }
}

PACKAGE_INFO("campbelltob3", CAMPBELLTOB3)
