/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-08-01
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SelectionWidget.h"
#include "GraphicObject.h"

namespace SciFigs {

SelectionWidget::SelectionWidget(GraphicObject* obj, QWidget * parent) :
    QWidget(parent)
{
  TRACE;
  _widget=obj;
  _state=Activated;
  _widget->setSelected(this);
  setToolTip(_widget->toolTip());
  setAttribute(Qt::WA_OpaquePaintEvent);
}

SelectionWidget::~SelectionWidget()
{
  TRACE;
  //cout << this << " selection is deleted" << endl;
  //_widget->setSelected(0);
}

void SelectionWidget::paintEvent(QPaintEvent * )
{
  TRACE;
  QPainter p(this);
  p.fillRect(0,0,width(),height(), Qt::white);
  switch (_state) {
  case Hoover:
    p.setPen(QPen(Qt::blue,SEL_WEIGHT));
    //p.setBrush(QBrush(Qt::blue));
    break;
  case Selected:
    p.setPen(QPen(Qt::gray,SEL_WEIGHT));
    //p.setBrush(QBrush(Qt::gray));
    break;
  case Activated:
    p.setPen(QPen(Qt::black,SEL_WEIGHT));
    //p.setBrush(QBrush(Qt::black));
    break;
  }
  /*p.drawRect(0,0,SEL_WEIGHT-1,SEL_WEIGHT-1);
  p.drawRect(width()-SEL_WEIGHT,0,SEL_WEIGHT-1,SEL_WEIGHT-1);
  p.drawRect(0,height()-SEL_WEIGHT,SEL_WEIGHT-1,SEL_WEIGHT-1);
  p.drawRect(width()-SEL_WEIGHT,height()-SEL_WEIGHT,SEL_WEIGHT-1,SEL_WEIGHT-1);*/
  p.drawRect(1,1,width()-SEL_WEIGHT,height()-SEL_WEIGHT);
}

void SelectionWidget::mousePressEvent (QMouseEvent * e)
{
  TRACE;
  _widget->mousePressEvent (e);
}

void SelectionWidget::mouseReleaseEvent (QMouseEvent *e)
{
  TRACE;
  _widget->mouseReleaseEvent (e);
}

void SelectionWidget::mouseMoveEvent (QMouseEvent * e)
{
  TRACE;
  _widget->mouseMoveEvent (e);
}

void SelectionWidget::mouseDoubleClickEvent (QMouseEvent * e)
{
  TRACE;
  _widget->mouseDoubleClickEvent (e);
}

void SelectionWidget::leaveEvent (QEvent * )
{
  TRACE;
  if(state()==Hoover) {
    _widget->setSelected(0);
    deleteLater();
  }
}

} // namespace SciFigs
