/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-12-11
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARALLELBANDS_H
#define PARALLELBANDS_H

#include "ParallelBand.h"
#include "GraphContentLayer.h"

namespace SciFigs {

class SCIFIGS_EXPORT ParallelBands :  public GraphContentLayer
{
  Q_OBJECT
  Q_PROPERTY(QString axisType READ axisTypeString WRITE setAxisType SCRIPTABLE true)
public:
  ParallelBands(AxisWindow * parent=nullptr);
  ~ParallelBands();

  virtual const QString& xml_tagName() const {return xmlParallelBandsTag;}
  static const QString xmlParallelBandsTag;

  void operator=(ParallelBands& o);
  void clear();

  virtual Rect boundingRect() const;

  void setAxisType(AxisType a);
  AxisType axisType() const {return _axisType;}
  QString axisTypeString() const {return _axisType==XAxis ?"X":"Y";}
  void setAxisType(QString t) {if(t.contains("X")) setAxisType(XAxis); else setAxisType(YAxis);}

  virtual bool trackRectangle(int, double rx1, double ry1, double rx2, double ry2, Qt::KeyboardModifiers);

  void addBand(const Brush& b, const Pen& p=Qt::NoPen);
  void addBand(double value, const Pen& p=Qt::SolidLine);
  void addBand(double min, double max, const Brush& b=Qt::SolidPattern, const Pen& p=Qt::NoPen);
  void addBand(const ParallelBand& b) {_bands.append(b);}
  void removeBand(int index);

  int count() const {return _bands.count();}
  ParallelBand& band(int index) {return _bands[index];}
  const ParallelBand& band(int index) const {return _bands[index];}
signals:
  void bandPicked(double min, double max);
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
protected:
  AxisType _axisType;
  QVector<ParallelBand> _bands;
};

} // namespace SciFigs

#endif // PARALLELBANDS_H
