/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-20
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PAINTPROGRESS_H
#define PAINTPROGRESS_H

#include <QtGui>
#include <QGpCoreTools.h>
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT PaintProgress: public QObject, public AbstractProgress
{
  Q_OBJECT
public:
  PaintProgress(QObject * parent=nullptr);

  void paint(QPainter& p, int w, int h);
  const QRect& boundingRect() const {return _updateRect;}

  void setActive(bool a) {_active=a;}
  bool isActive() const {return _active;}

  QString message() const {return _msg;}
protected:
  virtual void paint(QString caption, int value, int maximum);
signals:
  void repaint();
private:
  QRect _updateRect;
  QString _msg;

  bool _active;
};

} // namespace SciFigs

#endif // PAINTPROGRESS_H
