/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-20
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PaintProgress.h"

namespace SciFigs {

/*!
  \class PaintProgress PaintProgress.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

PaintProgress::PaintProgress(QObject * parent)
  : QObject(parent)
{
  _active=false;
  _updateRect.setWidth(1);  // Init the size of rectangle. If not initialized, the
  _updateRect.setHeight(1); // update triggered by GraphContent::paintProgress()
                            // is never achieved.
}

void PaintProgress::paint(QPainter& p, int w, int h)
{
  // Called only from gui thread, _msg and _updateRect are only touched by main thread.
  QFont f=p.font();
  f.setPointSize(8);
  p.setFont(f);
  QRect r=p.boundingRect(0, 0, w, h, Qt::TextWordWrap, _msg);
  int x=w/2-r.width()/2;
  int y=h/2-r.height()/2;
  p.setOpacity(0.7);
  p.setBrush(QBrush( Qt::white, Qt::SolidPattern) );
  p.setPen(Qt::NoPen);
  _updateRect.setTop(y-2);
  _updateRect.setLeft(x-2);
  _updateRect.setWidth(r.width()+4);
  _updateRect.setHeight(r.height()+4);
  p.drawRect(_updateRect);
  p.setOpacity(1.0);
  p.setPen(Qt::SolidLine);
  p.drawText(x, y, r.width(), r.height(), Qt::TextWordWrap, _msg);
}

/*!
  Only one function that can be called outside the main gui thread
*/
void PaintProgress::paint(QString caption, int value, int maximum)
{
  if(caption.isEmpty()) {
    _msg=valueString(value, maximum);
  } else {
    _msg=caption +"\n"+valueString(value, maximum);
  }
  emit repaint();
}

} // namespace SciFigs
