/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-19
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HISTOGRAMLAYER_H
#define HISTOGRAMLAYER_H

#include <QGpCoreMath.h>

#include "GraphContentLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT HistogramLayer : public GraphContentLayer
  {
    Q_OBJECT
  public:
    HistogramLayer(AxisWindow * parent=nullptr);
    ~HistogramLayer();

    virtual const QString& xml_tagName() const {return xmlHistogramLayerTag;}
    static const QString xmlHistogramLayerTag;

    void set(const Histogram& h);

    virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
    virtual Rect boundingRect() const;
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
  private:
    Histogram _histogram;
  };

} // namespace SciFigs

#endif // HISTOGRAMLAYER_H
