/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHICOBJECTFACTORY_H
#define GRAPHICOBJECTFACTORY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"
#include "GraphicObject.h"

namespace SciFigs {

  #define REGISTER_GRAPHICOBJECT(_className_, _tagName_, \
                                 _userName_, _menuTitle_, \
                                 _shortcut_, _toolTip_) \
    XMLREGISTER_HEAD(GraphicObjectFactory, GraphicObjectCreator, _className_, _tagName_) \
      virtual QString userName() const  {return _userName_;} \
      virtual QString menuTitle() const {return _menuTitle_;} \
      virtual QString shortcut() const {return _shortcut_;} \
      virtual QString toolTip() const {return _toolTip_;} \
      virtual QIcon icon() const {return QIcon(":" # _className_ ".png");} \
      virtual QString tagName() const {return _tagName_;} \
    XMLREGISTER_TAIL(_className_)

  #define SYNONYM_GRAPHICOBJECT(_synName_, _tagName_) \
    XMLSYNONYM(GraphicObjectFactory, _synName_, _tagName_)

  class GraphicObjectFactory;

  class SCIFIGS_EXPORT GraphicObjectCreator : public XMLClassCreator
  {
  public:
    virtual QString userName() const=0;
    virtual QString menuTitle() const=0;
    virtual QString shortcut() const=0;
    virtual QString toolTip() const=0;
    virtual QIcon icon() const=0;
    virtual QString tagName() const=0;
  };

  class SCIFIGS_EXPORT GraphicObjectFactory : public XMLClassFactory
  {
  public:
    inline GraphicObject * create(int id) const;
    inline GraphicObject * create(const QString& tag) const;
    inline GraphicObjectCreator * creator(const QString& tag) const;
    inline GraphicObjectCreator * creator(int id) const;

    static void init();
    static GraphicObjectFactory * instance() {init(); return _self;}
  private:
    static GraphicObjectFactory * _self;
  };

  inline GraphicObject * GraphicObjectFactory::create(int id) const
  {
    return static_cast<GraphicObject *>(XMLClassFactory::create(id));
  }

  inline GraphicObject * GraphicObjectFactory::create(const QString& tag) const
  {
    return static_cast<GraphicObject *>(XMLClassFactory::create(tag));
  }

  inline GraphicObjectCreator * GraphicObjectFactory::creator(const QString& tag) const
  {
    return static_cast<GraphicObjectCreator *>(XMLClassFactory::creator(tag));
  }

  inline GraphicObjectCreator * GraphicObjectFactory::creator(int id) const
  {
    return static_cast<GraphicObjectCreator *>(XMLClassFactory::creator(id));
  }

} // namespace SciFigs

#endif // GRAPHICOBJECTFACTORY_H
