/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-26
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef EXPORTOPTIONS_H
#define EXPORTOPTIONS_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

  class AxisWindow;

  class SCIFIGS_EXPORT ExportOptions
  {
  public:
    ExportOptions();
    ~ExportOptions();

    bool read(int& argc, char ** argv);
    static void help(ApplicationHelp * h);

    const QString& exportFile() const {return _exportFile;}
    const QString& exportFormat() const {return _exportFormat;}
    const QString& exportFileGraph() const {return _exportFileGraph;}
    QString exportFileGraph(int index) const;
    int dpi() const {return _dpi;}
    bool preserveScales() const {return _preserveScales;}
    const QString& legendFile() const {return _legendFile;}
    const QString& colorMapFile() const {return _colorMapFile;}
    const QStringList& makeupObjectFiles() const {return _makeupObjectFiles;}
    const QStringList& appendLayerFiles() const {return _appendLayerFiles;}
    const QStringList& prependLayerFiles() const {return _prependLayerFiles;}
  private:
    QString _exportFile, _exportFormat;
    int _dpi;
    bool _preserveScales;
    QString _exportFileGraph;
    QString _legendFile, _colorMapFile;
    QStringList _makeupObjectFiles;
    QStringList _appendLayerFiles, _prependLayerFiles;
  };

} // namespace SciFigs

#endif // EXPORTOPTIONS_H
