/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-19
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ComplexStatisticalLine.h"
#include "LineFactory.h"

namespace SciFigs {

/*!
  \class ComplexStatisticalLine ComplexStatisticalLine.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString ComplexStatisticalLine::xmlComplexStatisticalLineTag="ComplexStatisticalLine";

REGISTER_LINE(ComplexStatisticalLine, "ComplexStatisticalLine")

AbstractLine * ComplexStatisticalLine::clone() const
{
  ComplexStatisticalLine * l=new ComplexStatisticalLine;
  *l=*this;
  return l;
}

void ComplexStatisticalLine::operator=(const ComplexStatisticalLine& o)
{
  _curve=o._curve;
  AbstractLine::operator=(o);
}

Point ComplexStatisticalLine::point(int index, const CurvePointOptions * options) const
{
  TRACE;
  const AbstractComplexPointOptions * co=static_cast<const AbstractComplexPointOptions *>(options);
  const ComplexStatisticalPoint& dp=_curve.at(index);
  Point p;
  p.setX(dp.x());
  p.setZ(dp.stddev());
  if(co) {
    p.setY(co->toDouble(dp.x(), dp.mean()));
  } else {
    ComplexPointOptions co;
    p.setY(co.toDouble(dp.x(), dp.mean()));
  }
  return p;
}

void ComplexStatisticalLine::setY(int index, double v, const CurvePointOptions * options)
{
  TRACE;
  const AbstractComplexPointOptions * co=static_cast<const AbstractComplexPointOptions *>(options);
  ComplexStatisticalPoint& p=_curve[index];
  Complex c=p.mean();
  if(co) {
    co->fromDouble(p.x(), c, v);
  } else {
    ComplexPointOptions co;
    co.fromDouble(p.x(), c, v);
  }
  p.setMean(c);
}

} // namespace SciFigs
