/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-29
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODESELECTOR_H
#define MODESELECTOR_H

#include <QGpCoreWave.h>

#include "ui_ModeSelector.h"
#include "ModeDelegate.h"
#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

  class QGPGUIWAVE_EXPORT ModeSelector : public QWidget, private Ui::ModeSelector
  {
    Q_OBJECT
  public:
    ModeSelector(QWidget * parent=nullptr);
    ~ModeSelector();

    void setEditable(bool e);
    void setProxy(ModalProxy * p);

    void setModeType(Mode::Type t);
    void setDefaultModeIndex(int i) {_defaultIndex=i;}
    void setDefaultRingIndex(int i) {_defaultRingIndex=i;}
    Mode defaultMode() const;

    void beginModeChange();
    void endModeChange();
  private slots:
    void on_addBut_clicked();
    void on_removeBut_clicked();
  private:
    Mode::Type _type;
    int _defaultIndex, _defaultRingIndex;
  };

} // namespace QGpGuiWave

#endif // MODESELECTOR_H
