/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-31
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYPROXY_H
#define PROPERTYPROXY_H

#include <QtGui>
#include <QGpCoreTools.h>
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class PropertyTab;
class PropertyCategory;
class PropertyEditor;
class PropertyItem;
class PropertyWidget;

class QGPGUITOOLS_EXPORT PropertyProxy : public QObject
{
  Q_OBJECT
public:
  PropertyProxy(QObject * parent=nullptr);
  ~PropertyProxy();

  void raiseEditor(uint category);
  void setEditor();

  bool setCurrentCategory(uint category);
  bool setCurrentTab(uint tab);
  PropertyWidget * currentTabWidget() const;

  void addCategory(uint category, QString caption, QIcon icon);
  void addTab(uint tab, QString title, PropertyWidget * w, PropertyItem * item);
  void addReference(PropertyItem * item);
  bool hasReference() const;
  int referenceCount() const;
  void removeTab(uint tab, PropertyItem * item);

  void setTitle(QString t) {_title=t;}
  QString title() const {return _title;}

  void blockUpdates(bool b);
  void saveStates();
  void restoreStates();
  void setValues();
  void setCurrentTabValues();

  static uint uniqueId();
  static uint invalidId;
private:
  inline bool isActive() const;

  QString _title;
  PropertyCategory * _currentCategory;
  PropertyTab * _currentTab;
  QHash<uint, PropertyCategory *> _categories;
  bool _blockUpdates;
  static uint _lastUniqueId;
};

} // namespace QGpGuiTools

#endif // PROPERTYPROXY_H
