/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-05-09
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PropertyArea.h"

namespace QGpGuiTools {

/*!
  \class PropertyArea PropertyArea.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
PropertyArea::PropertyArea(QWidget * parent)
    : QScrollArea(parent)
{
  setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
}

/*!
  Description of destructor still missing
*/
PropertyArea::~PropertyArea()
{
}

QSize PropertyArea::minimumSizeHint() const
{
  QSize s;
  s.setHeight(200);
  if(widget()) {
    s.setWidth(widget()->minimumSizeHint().width()+20);
  }
  return s;
}

QSize PropertyArea::sizeHint() const
{
  return minimumSizeHint();
}

void PropertyArea::resizeEvent(QResizeEvent * e)
{
  resizeContent();
  QScrollArea::resizeEvent(e);
}

void PropertyArea::resizeContent()
{
  if(widget()) {
    QSize s=widget()->minimumSizeHint();
    if(s.width()<viewport()->width()) s.setWidth(viewport()->width());
    widget()->resize(s);
  }
}

} // namespace QGpGuiTools
