/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MultiDocumentTabWidget.h"
#include "MultiDocumentTab.h"
#include "MultiDocumentTabBar.h"
#include "Settings.h"

namespace QGpGuiTools {

/*!
  \class MultiDocumentTabWidget MultiDocumentTabWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MultiDocumentTabWidget::MultiDocumentTabWidget(QWidget * parent)
    : QTabWidget(parent)
{
  TRACE;
  // Signal from QTabWidget
  connect(this, SIGNAL(tabCloseRequested(int)), this, SIGNAL(closeTabRequested(int)));
  MultiDocumentTabBar * tb=new MultiDocumentTabBar(this);
  connect(tb, SIGNAL(newTabRequested(int)), this, SIGNAL(newTabRequested(int)));
  connect(tb, SIGNAL(renameTabRequested(int)), this, SLOT(renameTab(int)));
  connect(tb, SIGNAL(closeTabRequested(int)), this, SIGNAL(closeTabRequested(int)));
  connect(tb, SIGNAL(tabifyRequested(int)), this, SIGNAL(tabifyRequested(int)));
  connect(tb, SIGNAL(windowMenuRequested(int, QAction *&)), this, SLOT(windowMenu(int, QAction *&)));
  setTabBar(tb);
  setTabsClosable(true);
  setMovable(true);
  setDocumentMode(true);
  setAcceptDrops(true);
}

/*!
  Description of destructor still missing
*/
MultiDocumentTabWidget::~MultiDocumentTabWidget()
{
  TRACE;
}

void MultiDocumentTabWidget::addTab(MultiDocumentTab * t)
{
  TRACE;
  connect(t, SIGNAL(activateRequested(QWidget *)), this, SLOT(setCurrentWidget(QWidget *)));
  // Queued connection lets a proper update of the sub window list
  connect(t, SIGNAL(nameChanged()), this, SLOT(updateName()), Qt::QueuedConnection);
  QTabWidget::insertTab(count(), t, t->name());
  addCloseButton(count()-1);
  setCurrentIndex(count()-1);
}

void MultiDocumentTabWidget::insertTab(int at, MultiDocumentTab * t)
{
  TRACE;
  connect(t, SIGNAL(activateRequested(QWidget *)), this, SLOT(setCurrentWidget(QWidget *)));
  // Queued connection lets a proper update of the sub window list
  connect(t, SIGNAL(nameChanged()), this, SLOT(updateName()), Qt::QueuedConnection);
  QTabWidget::insertTab(at, t, t->name());
  addCloseButton(at);
  setCurrentIndex(at);
}

void MultiDocumentTabWidget::closeTab(bool)
{
  TRACE;
  QToolButton * bt=qobject_cast<QToolButton *>(sender());
  if(bt) {
    bool ok;
    QWidget * w=reinterpret_cast<QWidget *>(bt->property("TabWidget").toULongLong(&ok));
    if(ok) {
      int index=indexOf(w);
      if(index>=0) {
        emit closeTabRequested(index);
      }
    }
  }
}

void MultiDocumentTabWidget::windowMenu(int index, QAction *& m)
{
  TRACE;
  MultiDocumentTab * t=tab(index);
  m=t->windowMenuAction();
}

void MultiDocumentTabWidget::addCloseButton(int index)
{
  TRACE;
#ifndef Q_OS_MAC
  QIcon ic(":closetab.png");
  ic.addPixmap(QPixmap(":closetabactive.png"), QIcon::Active);
  QToolButton * bt=new QToolButton();
  bt->setIcon(ic);
  bt->setToolButtonStyle(Qt::ToolButtonIconOnly);
  bt->setMinimumSize(QSize(20, 20));
  bt->setMaximumSize(QSize(20, 20));
  bt->setAutoRaise(true);
  bt->setProperty("TabWidget", reinterpret_cast<qint64>(widget(index)));
  connect(bt, SIGNAL(clicked(bool)), this, SLOT(closeTab(bool)));
  tabBar()->setTabButton(index, QTabBar::RightSide, bt);
#endif
}

MultiDocumentTab * MultiDocumentTabWidget::tab(int index)
{
  TRACE;
  return qobject_cast<MultiDocumentTab *>(widget(index));
}

void MultiDocumentTabWidget::renameTab(int at)
{
  TRACE;
  MultiDocumentTab * t=tab(at);
  bool ok;
  QString text=Settings::getText(QApplication::activeWindow(),
                                 tr("Rename tab"),
                                 tr("Tab's name:"),
                                 QLineEdit::Normal, t->name(), &ok);
  if(ok) {
    t->setName(text);
  }
}

void MultiDocumentTabWidget::updateName()
{
  TRACE;
   MultiDocumentTab * t=qobject_cast<MultiDocumentTab *>(sender());
   if(t) {
     int i=indexOf(t);
     setTabText(i, t->name());
   }
}

} // namespace QGpGuiTools
