/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ColumnTextSectionsProperties.h"

namespace QGpGuiTools {

/*!
  \class ColumnTextSectionsProperties ColumnTextSectionsProperties.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ColumnTextSectionsProperties::ColumnTextSectionsProperties(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
ColumnTextSectionsProperties::~ColumnTextSectionsProperties()
{
  TRACE;
}

void ColumnTextSectionsProperties::updateWidgets()
{
  on_isLinePattern_toggled();
  on_isLineCount_toggled();
  on_isRowCount_toggled();
  on_isCellPattern_toggled();
}

void ColumnTextSectionsProperties::on_isLinePattern_toggled()
{
  linePattern->setEnabled(isLinePattern->isChecked());
}

void ColumnTextSectionsProperties::on_isLineCount_toggled()
{
  lineCount->setEnabled(isLineCount->isChecked());
}

void ColumnTextSectionsProperties::on_isRowCount_toggled()
{
  rowCount->setEnabled(isRowCount->isChecked());
}

void ColumnTextSectionsProperties::on_isCellPattern_toggled()
{
  cellColumn->setEnabled(isCellPattern->isChecked());
  matchesLabel->setEnabled(isCellPattern->isChecked());
  cellPattern->setEnabled(isCellPattern->isChecked());
}

} // namespace QGpGuiTools
