/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-03-05
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COORDINATECONVERT_H
#define COORDINATECONVERT_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreMath.h>

#include "ui_CoordinateConvert.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT CoordinateConvert : public QWidget, private Ui::CoordinateConvert
  {
    Q_OBJECT
  public:
    CoordinateConvert(QWidget * parent=nullptr);
    ~CoordinateConvert();

    enum Projection {Local, UniversalTransverseMercator};
    Projection projection() const;

    void popupCopyMenu(QMenu * m);

    Point2D reference() const;
    void setReference(const Point2D& p);
    void saveReference() const;

    void setUtmZone(const UtmZone &z);
    UtmZone utmZone();
  private slots:
    void on_localProjection_toggled(bool checked);
    void utmZoneTouched();
  signals:
    void copyReference();
  private:
    QMenu * _copyMenu;
    bool _utmZoneTouched;
  };

} // namespace QGpGuiMath

#endif // COORDINATECONVERT_H
