/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MODALPROXY_H
#define MODALPROXY_H

#include <QGpCoreMath.h>

#include "ModalCurve.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class QGPCOREWAVE_EXPORT ModalProxy : public CurveProxy
  {
  public:
    ModalProxy() : CurveProxy() {_curve=nullptr;}

    CURVEPROXY_BASICDECLARATIONS
    CURVEPROXY_NAMEDECLARATIONS
    CURVEPROXY_LOGDECLARATIONS
    void average(const CurveProxy * o) {
      curve().average(static_cast<const ModalProxy *>(o)->curve());
    }


    void addMode(const Mode& m) {curve().addMode(m);}
    void removeMode(int index) {curve().removeMode(index);}
    const QList<Mode>& modes() const {return curve().modes();}
    QList<Mode>& modes() {return curve().modes();}

    void setCurve(ModalCurve * c) {_curve=c;}
    const ModalCurve& curve() const {return *_curve;}
    ModalCurve& curve() {return *_curve;}
  private:
    ModalCurve * _curve;
  };

} // namespace QGpCoreWave

#endif // MODALPROXY_H

