/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-10-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "EllipticityFactory.h"
#include "ModalCurve.h"

namespace QGpCoreWave {

/*!
  \class EllipticityFactory EllipticityFactory.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

EllipticityFactory::EllipticityFactory()
{
  TRACE;
  _signedValues=nullptr;
  _absoluteValues=nullptr;
}

EllipticityFactory::~EllipticityFactory()
{
  TRACE;
  delete _signedValues;
  delete _absoluteValues;
}

void EllipticityFactory::setMode (const Mode& m)
{
  TRACE;
  upgrade(_signedValues, m.index());
  if(m.value()==Mode::Absolute) {
    upgrade(_absoluteValues, m.index());
  }
}

const RealValue * EllipticityFactory::mode(const Mode& m) const
{
  switch(m.value()) {
  case Mode::Signed:
    return _signedValues ? _signedValues->mode(m.index()) : nullptr;
  case Mode::Absolute:
    return _absoluteValues ? _absoluteValues->mode(m.index()) : nullptr;
  }
  return nullptr; // just to avoid warning
}

double EllipticityFactory::peakMisfit(const RealStatisticalValue& val, DispersionFactory& disp, const Seismic1DModel * model)
{
  TRACE;
  if(_signedValues && disp.phaseRayleigh()) {
    Rayleigh rayleigh(model);
    // TODO generalize to n modes
    double m=_signedValues->peakMisfit(0, val, *disp.phaseRayleigh(), &rayleigh);
    return m;
  } else return 0.0;
}

} // namespace QGpCoreWave
