/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SMOOTHINGPARAMETERS_H
#define SMOOTHINGPARAMETERS_H

#include <QGpCoreTools.h>

#include "WindowFunction.h"
#include "SamplingParameters.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT SmoothingParameters: public AbstractParameters
  {
  public:
    SmoothingParameters();
    SmoothingParameters(const SmoothingParameters& o);

    virtual AbstractParameters * clone() const {return new SmoothingParameters(*this);}

    enum Method {Function, SavitzkyGolay};
    enum WidthType {Constant, Proportional, Log};

    Method method() const {return _method;}
    void setMethod(Method m) {_method=m;}

    WidthType widthType() const {return _widthType;}
    void setWidthType(WidthType t) {_widthType=t;}

    void setWidth(double w) {if(w>=0.0) _width=w;}
    double width() const {return _width;}

    int order() const {return _order;}
    void setOrder(int o) {if(o>0) _order=o;}

    SamplingParameters::Type scaleType() const {return _scaleType;}
    void setScaleType(SamplingParameters::Type t) {_scaleType=t;}

    const WindowFunctionParameters& windowFunction() const {return _windowFunction;}
    WindowFunctionParameters& windowFunction() {return _windowFunction;}
    
    double minimum(double x0) const;
    double maximum(double x0) const;

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
    int totalKeywordCount(PARAMETERS_TOTALKEYWORDCOUNT_ARGS) const;
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    QString methodString() const;
    void setMethod(const QString& t);

    QString widthTypeString() const;
    void setWidthType(const QString& t);
    void setWidthTypeCompatibility(const QString& t);
    void setWidthCompatibility(double w);

    Method _method;
    WidthType _widthType;
    double _width;
    int _order;
    SamplingParameters::Type _scaleType;
    WindowFunctionParameters _windowFunction;
  };

} // namespace QGpCoreMath

#endif // SMOOTHINGPARAMETERS_H
